/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.networksettings;

import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.tasks.networksettings.NetworkSettingsConstants;
import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.base.settings.network.config.DHCPServerRangeConfig;

public class NetworkSettingsDHCPServerSettings
implements NetworkSettingsConstants {
    public static final String BEAN_NAME = "NetworkSettingsDHCPServerSettings";
    private static final String TRACE_MASKD = "JNSWNSDD";
    private static final String TRACE_MASKF = "JNSWNSDF";
    private static final String TRACE_MASKT = "JNSWNSDT";
    private String m_sIPAddress;
    private String m_sSubnetMask;
    private String m_sDefaultRoute;
    private String m_sBeanName;
    private DHCPServerRangeConfig m_oDHCPServerRangeConfig;
    private boolean m_bChangeFlag;
    private boolean m_bChangedSinceLastUpdate;

    public NetworkSettingsDHCPServerSettings() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsDHCPServerSettings Default Constructor");
        }
        this.m_sIPAddress = "";
        this.m_sSubnetMask = "";
        this.m_sDefaultRoute = "";
        this.m_bChangeFlag = false;
        this.m_bChangedSinceLastUpdate = false;
        this.m_sBeanName = BEAN_NAME;
        this.m_oDHCPServerRangeConfig = null;
    }

    public String getIPAddress() {
        return this.m_sIPAddress;
    }

    public void setIPAddress(String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsDHCPServerSettings setIPAddress called IP address = " + string);
        }
        this.m_sIPAddress = string.trim();
        this.m_bChangeFlag = true;
        this.m_bChangedSinceLastUpdate = true;
    }

    public String getSubnetMask() {
        return this.m_sSubnetMask;
    }

    public void setSubnetMask(String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsDHCPServerSettings setSubnetMask called subnet mask = " + string);
        }
        this.m_sSubnetMask = string.trim();
        this.m_bChangeFlag = true;
        this.m_bChangedSinceLastUpdate = true;
    }

    public String getDefaultRoute() {
        return this.m_sDefaultRoute;
    }

    public void setDefaultRoute(String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsDHCPServerSettings setDefaultRoute called default route = " + string);
        }
        this.m_sDefaultRoute = string.trim();
        this.m_bChangeFlag = true;
        this.m_bChangedSinceLastUpdate = true;
    }

    public DHCPServerRangeConfig getDHCPServerRangeConfig() {
        return this.m_oDHCPServerRangeConfig;
    }

    public void setDHCPServerRangeConfig(DHCPServerRangeConfig dHCPServerRangeConfig) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsDHCPServerSettings setDHCPServerRangeConfig called");
        }
        this.m_oDHCPServerRangeConfig = dHCPServerRangeConfig;
        this.m_bChangeFlag = true;
        this.m_bChangedSinceLastUpdate = true;
    }

    public String getBeanName() {
        return this.m_sBeanName;
    }

    public boolean isChanged() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsDHCPServerSettings isChanged returning " + this.m_bChangeFlag);
        }
        return this.m_bChangeFlag;
    }

    public boolean isChangedSinceLastUpdate() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsDHCPServerSettings isChangedSinceLastUpdate returning " + this.m_bChangedSinceLastUpdate);
        }
        return this.m_bChangedSinceLastUpdate;
    }

    public void updateNetworkInterfaceInformation(NetworkInterfaceInformation networkInterfaceInformation) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsDHCPServerSettings updateNetworkInterfaceInformation called");
        }
        if (this.isChangedSinceLastUpdate()) {
            if (this.m_oDHCPServerRangeConfig != null) {
                networkInterfaceInformation.setDhcpServerRangeConfig(this.m_oDHCPServerRangeConfig);
            }
            this.m_bChangedSinceLastUpdate = false;
        }
    }
}

